import os, xbmc, xbmcaddon

#########################################################
### User Edit Variables #################################
#########################################################
ADDON_ID       = xbmcaddon.Addon().getAddonInfo('id')
ADDONTITLE     = 'Nwi Firesticks Wizard'
EXCLUDES       = [ADDON_ID]
# Text File with build info in it.
BUILDFILE      = 'http://nwifiresticks.com/wizardv4/Texts/autobuilds.txt'
# How often you would list it to check for build updates in days
# 0 being every startup of kodi
UPDATECHECK    = 0
# Text File with apk info in it.  Leave as 'http://' to ignore
APKFILE        = 'http://nwifiresticks.com/wizardv4/Texts/apk.txt'
# Text File with Youtube Videos urls.  Leave as 'http://' to ignore
YOUTUBETITLE   = 'Nwi Firesticks Tutorials'
YOUTUBEFILE    = 'http://nwifiresticks.com/wizardv4/Texts/youtube.txt'
# Text File for addon installer.  Leave as 'http://' to ignore
ADDONFILE      = 'http://nwifiresticks.com/wizardv4/Texts/addons.txt'
# Text File for advanced settings.  Leave as 'http://' to ignore
ADVANCEDFILE   = 'http://nwifiresticks.com/wizardv4/Texts/Advanced.txt'
# Text file for roms and emus
ROMPACK        = 'http://nwifiresticks.com/wizardv4/Texts/roms.txt'
EMUAPKS        = 'http://nwifiresticks.com/wizardv4/Texts/emulator.txt'

# Dont need to edit just here for icons stored locally
PATH           = xbmcaddon.Addon().getAddonInfo('path')
ART            = os.path.join(PATH, 'resources', 'art')

#########################################################
### THEMING MENU ITEMS ##################################
#########################################################
# If you want to use locally stored icons the place them in the Resources/Art/
# folder of the wizard then use os.path.join(ART, 'imagename.png')
# do not place quotes around os.path.join
# Example:  ICONMAINT     = os.path.join(ART, 'mainticon.png')
#           ICONSETTINGS  = 'http://aftermathwizard.net/repo/wizard/settings.png'
# Leave as http:// for default icon
ICONBUILDS     = 'http://nwifiresticks.com/wizardv4/Images/IconBuilds.png'
ICONMAINT      = 'http://nwifiresticks.com/wizardv4/Images/IconMaintain.png'
ICONSPEED      = 'http://nwifiresticks.com/wizardv4/Images/IconTools.png'
ICONAPK        = 'http://nwifiresticks.com/wizardv4/Images/IconApkInstaller.png'
ICONRETRO      = 'http://nwifiresticks.com/wizardv4/Images/IconRetro.png'
ICONADDONS     = 'http://nwifiresticks.com/wizardv4/Images/IconAddonInstaller.png'
ICONYOUTUBE    = 'http://nwifiresticks.com/wizardv4/Images/IconTutorials.png'
ICONSAVE       = 'http://nwifiresticks.com/wizardv4/Images/IconData.png'
ICONTRAKT      = 'http://nwifiresticks.com/wizardv4/Images/IconTrakt.png'
ICONREAL       = 'http://nwifiresticks.com/wizardv4/Images/IconDebrid.png'
ICONLOGIN      = 'http://nwifiresticks.com/wizardv4/Images/IconSaveLogin.png'
ICONCONTACT    = 'http://nwifiresticks.com/wizardv4/Images/IconContact.png'
ICONSETTINGS   = 'http://nwifiresticks.com/wizardv4/Images/IconSettings.png'
# Hide the ====== seperators 'Yes' or 'No'
HIDESPACERS    = 'No'
# Character used in seperator
SPACER         = '~'

# You can edit these however you want, just make sure that you have a %s in each of the
# THEME's so it grabs the text from the menu item
COLOR1         = 'darkred'
COLOR2         = 'white'
# Primary menu items   / %s is the menu item and is required
THEME1         = '[COLOR '+COLOR1+'][B]([COLOR '+COLOR2+']Nwi Firesticks[/COLOR])[/B][/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'
# Build Names          / %s is the menu item and is required
THEME2         = '[COLOR '+COLOR2+']%s[/COLOR]'
# Alternate items      / %s is the menu item and is required
THEME3         = '[COLOR '+COLOR1+']%s[/COLOR]'
# Current Build Header / %s is the menu item and is required
THEME4         = '[COLOR '+COLOR1+'][B]Current Build:[/B][/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'
# Current Theme Header / %s is the menu item and is required
THEME5         = '[COLOR '+COLOR1+'][B]Current Theme:[/B][/COLOR] [COLOR '+COLOR2+']%s[/COLOR]'

# Message for Contact Page
# Enable 'Contact' menu item 'Yes' hide or 'No' dont hide
HIDECONTACT    = 'No'
# You can add \n to do line breaks
CONTACT        = 'Thank you for choosing Nwi Firesticks Wizard.\r\n\r\nContact me on at http://www.facebook.com/nwifiresticks'
#Images used for the contact window.  http:// for default icon and fanart
CONTACTICON    = 'http://'
CONTACTFANART  = 'http://'
#########################################################

#########################################################
### AUTO UPDATE #########################################
########## FOR THOSE WITH NO REPO #######################
# Enable Auto Update 'Yes' or 'No'
AUTOUPDATE     = 'Yes'
# Url to wizard version
WIZARDFILE     = 'http://nwifiresticks.com/wizardv4/Texts/autobuilds.txt'
#########################################################

#########################################################
### AUTO INSTALL ########################################
########## REPO IF NOT INSTALLED ########################
# Enable Auto Install 'Yes' or 'No'
AUTOINSTALL    = 'No'
# Addon ID for the repository
REPOID         = ''
# Url to Addons.xml file in your repo folder(this is so we can get the latest version)
REPOADDONXML   = 'http://'
# Url to folder zip is located in
REPOZIPURL     = 'http://'
#########################################################

#########################################################
### NOTIFICATION WINDOW##################################
#########################################################
# Enable Notification screen Yes or No
ENABLE         = 'Yes'
# Url to notification file
NOTIFICATION   = 'http://nwifiresticks.com/wizardv4/Texts/notify.txt'
# Use either 'Text' or 'Image'
HEADERTYPE     = 'Text'
HEADERMESSAGE  = 'Nwi Firesticks Wizard'
# url to image if using Image 500x50(Width can vary but height of image needs to be 50px)
HEADERIMAGE    = ''
# Background for Notification Window
BACKGROUND     = ''
#########################################################