# -*- coding: utf-8 -*-

'''
    Jizz Planet Add-on

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
import sys,re
import six
from six.moves import urllib_parse

params = dict(urllib_parse.parse_qsl(sys.argv[2].replace('?','')))

action = params.get('action')

content = params.get('content')

name = params.get('name')

url = params.get('url')

image = params.get('image')

fanart = params.get('fanart')


if action == None:
    from resources.lib.indexers import jizzplanet
    jizzplanet.indexer().root()

elif action == 'directory':
    from resources.lib.indexers import jizzplanet
    jizzplanet.indexer().get(url)

elif action == 'qdirectory':
    from resources.lib.indexers import jizzplanet
    jizzplanet.indexer().getq(url)

elif action == 'xdirectory':
    from resources.lib.indexers import jizzplanet
    jizzplanet.indexer().getx(url)

elif action == 'developer':
    from resources.lib.indexers import jizzplanet
    jizzplanet.indexer().developer()


elif action == 'play':
    from resources.lib.indexers import jizzplanet
    jizzplanet.player().play(url, content)


elif action == 'queueItem':
    from resources.lib.modules import control
    control.queueItem()

elif action == 'openSettings':
    from resources.lib.modules import control
    control.openSettings()

elif action == 'urlresolverSettings':
    from resources.lib.modules import control
    control.openSettings(id='script.module.resolveurl')

elif action == 'addView':
    from resources.lib.modules import views
    views.addView(content)


elif action == 'clearCache':
    from resources.lib.modules import cache
    cache.cache_clear()


