################################################################################
#      Copyright (C) 2015 Surfacingx                                           #
#                                                                              #
#  This Program is free software; you can redistribute it and/or modify        #
#  it under the terms of the GNU General Public License as published by        #
#  the Free Software Foundation; either version 2, or (at your option)         #
#  any later version.                                                          #
#                                                                              #
#  This Program is distributed in the hope that it will be useful,             #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of              #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                #
#  GNU General Public License for more details.                                #
#                                                                              #
#  You should have received a copy of the GNU General Public License           #
#  along with XBMC; see the file COPYING.  If not, write to                    #
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.       #
#  http://www.gnu.org/copyleft/gpl.html                                        #
################################################################################
import sys, time, uservar
import six
from kodi_six import xbmc, xbmcaddon, xbmcgui, xbmcplugin,  xbmcvfs
from six.moves import urllib_parse, urllib_request
# Py2
try:
    import wizard as wiz

# Py3:
except ImportError:
    from resources.libs import wizard as wiz


ADDONTITLE     = uservar.ADDONTITLE
COLOR1         = uservar.COLOR1
COLOR2         = uservar.COLOR2

urllib_request.URLopener.version = 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/35.0.1916.153 Safari/537.36 SE 2.X MetaSr 1.0'

def download(url, dest, dp = None, bname = None):
    opener = urllib_request.build_opener()
    opener.addheaders = [('User-agent', 'Mozilla/5.0')]
    urllib_request.install_opener(opener)
    if not dp:
        dp = xbmcgui.DialogProgress()
        dp.create(ADDONTITLE ,"Downloading")
    dp.update(0)
    start_time=time.time()
    bn = bname
    urllib_request.urlretrieve(url, dest, lambda nb, bs, fs: _pbhook(nb, bs, fs, dp, start_time, bn))

def _pbhook(numblocks, blocksize, filesize, dp, start_time, bn):
    try: 
        percent = min(numblocks * blocksize * 100 / filesize, 100) 
        currently_downloaded = float(numblocks) * blocksize / (1024 * 1024) 
        kbps_speed = numblocks * blocksize / (time.time() - start_time) 
        if kbps_speed > 0 and not percent == 100: 
            eta = (filesize - numblocks * blocksize) / kbps_speed 
        else: 
            eta = 0
        kbps_speed = kbps_speed / 1024 
        type_speed = 'KB'
        if kbps_speed >= 1024:
            kbps_speed = kbps_speed / 1024 
            type_speed = 'MB'
        total = float(filesize) / (1024 * 1024) 
        mbs = '\n%.02fMB of [COLOR %s]%.02f[/COLOR]MB' % (currently_downloaded, COLOR1, total) 
        e   = '\n[COLOR %s][B]Speed:[/B] [COLOR %s]%.02f [/COLOR]%s/s ' % (COLOR2, COLOR1, kbps_speed, type_speed)
        e  += '[B]ETA:[/B] [COLOR '+COLOR1+']%02d:%02d[/COLOR][/COLOR]' % divmod(eta, 60)
        xbmc.log('bn= ' + str(bn), xbmc.LOGINFO)
        dp.update(int(percent), '[B]Downloading:[/B] %s %s %s'% (bn.replace('None', 'white'), mbs, e))
    except Exception as e:
        wiz.log("ERROR Downloading: %s" % str(e), xbmc.LOGERROR)
        pass
    if dp.iscanceled(): 
        dp.close()
        wiz.LogNotify("[COLOR %s]%s[/COLOR]" % (COLOR1, ADDONTITLE), "[COLOR %s]Download Cancelled[/COLOR]" % COLOR2)
        sys.exit()
