# -*- coding: utf-8 -*-

from six.moves.urllib_parse import parse_qsl


def router(_argv):
    params = dict(parse_qsl(_argv.replace('?', '')))
    action = params.get('action')
    title = params.get('title')
    id = params.get('id')
    url = params.get('url')
    query = params.get('query')
    setting = params.get('setting')

    if action == None:
        from resources.lib.indexers import navigator
        navigator.main_menu().root()

    elif action == 'open_root':
        from resources.lib.indexers import navigator
        navigator.main_menu().root()

    elif action == 'site_iptv_menu':
        from resources.lib.indexers import navigator
        navigator.main_menu().site_iptv_menu()

    elif action == 'site_music_menu':
        from resources.lib.indexers import navigator
        navigator.main_menu().site_music_menu()

    elif action == 'tools_menu':
        from resources.lib.indexers import navigator
        navigator.main_menu().tools()

    elif action == 'play':
        from resources.lib.modules import player
        player.play(url, title)

    elif action == 'open_settings':
        from resources.lib.modules import control
        control.openSettings(query, id)

    elif action == 'color_choice':
        from resources.lib.modules import colorcode
        colorcode.colorChoice(setting, query)

    elif action == 'view_information':
        from resources.lib.modules import log_utils
        log_utils.view_information()

    elif action == 'view_changelog':
        from resources.lib.modules import log_utils
        log_utils.view_changelog()

    elif action == 'view_debuglog':
        from resources.lib.modules import log_utils
        log_utils.view_debuglog()

    elif action == 'empty_debuglog':
        from resources.lib.modules import log_utils
        log_utils.empty_debuglog()

    elif action == 'json_iptv_menu':
        from resources.lib.indexers import iptv_json
        iptv_json.menu().root()

    elif action == 'json_iptv_scrape_category':
        from resources.lib.indexers import iptv_json
        iptv_json.menu().scrape_category(url)

    elif action == 'json_iptv_scrape_channel':
        from resources.lib.indexers import iptv_json
        iptv_json.menu().scrape_channel(url)

    elif action == 'nightride_streamsafe_menu':
        from resources.lib.indexers import music_site
        music_site.nightride().streamsafe()

    elif action == 'nightride_stations_menu':
        from resources.lib.indexers import music_site
        music_site.nightride().stations()

    elif action == 'funcube_menu':
        from resources.lib.indexers import iptv_site
        iptv_site.funcube().root()

    elif action == 'toonamiaftermath_menu':
        from resources.lib.indexers import iptv_site
        iptv_site.toonamiaftermath().root()

    elif action == 'toonamiaftermath_scrape_channel':
        from resources.lib.indexers import iptv_site
        iptv_site.toonamiaftermath().scrape_channel(title, url)

    elif action == 'watchyourtv_menu':
        from resources.lib.indexers import iptv_site
        iptv_site.watchyourtv().root()

    elif action == 'watchyourtv_scrape_category':
        from resources.lib.indexers import iptv_site
        iptv_site.watchyourtv().scrape_category(url)

    elif action == 'watchyourtv_scrape_channel':
        from resources.lib.indexers import iptv_site
        iptv_site.watchyourtv().scrape_channel(url)

    elif action == 'personal_menu':
        from resources.lib.indexers import navigator
        navigator.main_menu().personal_menu()

    elif action == 'personal_lists_menu':
        from resources.lib.indexers import iptv_personal
        iptv_personal.Indexer().personal_lists()

    elif action == 'personal_m3u8_menu':
        from resources.lib.indexers import iptv_personal
        iptv_personal.Indexer().personal_m3u8_lists()

    elif action == 'personal_channels_menu':
        from resources.lib.indexers import iptv_personal
        iptv_personal.Indexer().personal_channels()

    elif action == 'personal_scrape':
        from resources.lib.indexers import iptv_personal
        iptv_personal.Indexer().scrape_channel(url)

    elif action == 'personal_m3u8_scrape':
        from resources.lib.indexers import iptv_personal
        iptv_personal.Indexer().scrape_m3u8(url)


