# -*- coding: utf-8 -*-

from resources.lib.modules import client
from resources.lib.modules import directory as lets
from resources.lib.modules import log_utils


class menu:
    def __init__(self):
        self.list = []
        self.categories = [
            {'title': 'Some IPTV Channels', 'url': 'iptv_channels', 'image': None},
            {'title': 'Some Radio Providers', 'url': 'radio_providers', 'image': None},
            {'title': 'Some IPTV Providers', 'url': 'iptv_providers', 'image': None}
        ]
        self.iptv_channels = [
            {'title': 'CricHD List', 'url': 'crichd_list', 'image': None},
            {'title': 'Mixed List', 'url': 'mixed_list', 'image': None},
            {'title': 'Canada List', 'url': 'ca_list', 'image': None},
            {'title': 'UK List', 'url': 'uk_list', 'image': None}
        ]
        self.radio_providers = [
            {'title': '0nRadio Channels', 'url': '_0nRadio', 'image': None},
            {'title': '181FM Channels', 'url': '_181FM', 'image': None},
            {'title': 'BigRRadio Channels', 'url': 'BigRRadio', 'image': None},
            {'title': 'DashRadio Channels', 'url': 'DashRadio', 'image': None},
            {'title': 'GotRadio Channels', 'url': 'GotRadio', 'image': None},
            {'title': 'SomaFM Channels', 'url': 'SomaFM', 'image': None},
            {'title': 'WeAreOneFM Channels', 'url': 'WeAreOneFM', 'image': None}
        ]
        self.iptv_providers = [
            {'title': 'AdultSwim Channels', 'url': 'AdultSwim', 'image': None},
            {'title': 'AnthymTV Channels', 'url': 'AnthymTV', 'image': None},
            {'title': 'AvoTV Channels', 'url': 'AvoTV', 'image': None},
            {'title': 'BumbleBeeTV Channels', 'url': 'BumbleBeeTV', 'image': None},
            {'title': 'DistroTV Channels', 'url': 'DistroTV', 'image': None},
            {'title': 'FreeliTV Channels', 'url': 'FreeliTV', 'image': None},
            {'title': 'GalxyTV Channels', 'url': 'GalxyTV', 'image': None},
            {'title': 'GlewedTV Channels', 'url': 'GlewedTV', 'image': None},
            {'title': 'HerogoTV Channels', 'url': 'HerogoTV', 'image': None},
            {'title': 'ImdbTV Channels', 'url': 'ImdbTV', 'image': None},
            {'title': 'JungoPlusTV Channels', 'url': 'JungoPlusTV', 'image': None},
            {'title': 'KlowdTV Channels', 'url': 'KlowdTV', 'image': None},
            {'title': 'LocalbTV Channels', 'url': 'LocalbTV', 'image': None},
            {'title': 'LocalNow Channels', 'url': 'LocalNow', 'image': None},
            {'title': 'MuzzikTV Channels', 'url': 'MuzzikTV', 'image': None},
            {'title': 'MyTvToGo Channels', 'url': 'MyTvToGo', 'image': None},
            {'title': 'Pbs Channels', 'url': 'Pbs', 'image': None},
            {'title': 'Plex Channels', 'url': 'Plex', 'image': None},
            {'title': 'PlutoTV Channels', 'url': 'PlutoTV', 'image': None},
            {'title': 'RadTV Channels', 'url': 'RadTV', 'image': None},
            {'title': 'RedBoxTV Channels', 'url': 'RedBoxTV', 'image': None},
            {'title': 'Roku Channels', 'url': 'Roku', 'image': None},
            {'title': 'SamsungTV Channels', 'url': 'SamsungTV', 'image': None},
            {'title': 'SimulTV Channels', 'url': 'SimulTV', 'image': None},
            {'title': 'SmashPlus Channels', 'url': 'SmashPlus', 'image': None},
            {'title': 'StirrTV Channels', 'url': 'StirrTV', 'image': None},
            {'title': 'Stream4Free Channels', 'url': 'Stream4Free', 'image': None},
            {'title': 'Tcl Channels', 'url': 'Tcl', 'image': None},
            {'title': 'Tubi Channels', 'url': 'Tubi', 'image': None},
            {'title': 'TV25 Channels', 'url': 'TV25', 'image': None},
            {'title': 'VeelyTV Channels', 'url': 'VeelyTV', 'image': None},
            {'title': 'VisionTV Channels', 'url': 'VisionTV', 'image': None},
            {'title': 'VizioTV Channels', 'url': 'VizioTV', 'image': None},
            {'title': 'WatchYourTV Channels', 'url': 'WatchYourTV', 'image': None},
            {'title': 'Wfmz Channels', 'url': 'Wfmz', 'image': None},
            {'title': 'Xumo Channels', 'url': 'Xumo', 'image': None}
        ]


    def root(self):
        try:
            for i in self.categories:
                self.list.append({'title': client.replaceHTMLCodes(i['title']), 'url': i['url'], 'image': i['image'], 'action': 'json_iptv_scrape_category'})
            lets.addDirectory(self.list)
            return self.list
        except:
            log_utils.log('root', 1)
            return self.list


    def scrape_category(self, url):
        try:
            if url == 'iptv_channels':
                subcategories = self.iptv_channels
            elif url == 'radio_providers':
                subcategories = self.radio_providers
            elif url == 'iptv_providers':
                subcategories = self.iptv_providers
            for i in subcategories:
                self.list.append({'title': client.replaceHTMLCodes(i['title']), 'url': i['url'], 'image': i['image'], 'action': 'json_iptv_scrape_channel'})
            lets.addDirectory(self.list)
            return self.list
        except:
            log_utils.log('scrape_category', 1)
            return self.list


    def scrape_channel(self, url):
        try:
            channels = self.parse_channel_lists(url)
            for i in channels:
                self.list.append({'title': client.replaceHTMLCodes(i['title']), 'url': i['url'], 'image': i['image'], 'action': 'play'})
            lets.addDirectory(self.list)
            return self.list
        except:
            log_utils.log('scrape_channel', 1)
            return self.list


    def parse_channel_lists(self, url):
        try:
            if url == 'mixed_list':
                from resources.lib.channels import mixed_list as channel_list
            elif url == 'crichd_list':
                from resources.lib.channels import crichd_list as channel_list
            elif url == 'ca_list':
                from resources.lib.channels import ca_list as channel_list
            elif url == 'uk_list':
                from resources.lib.channels import uk_list as channel_list

            elif url == '_0nRadio':
                from resources.lib.channels.radio import _0nRadio as channel_list
            elif url == '_181FM':
                from resources.lib.channels.radio import _181FM as channel_list
            elif url == 'BigRRadio':
                from resources.lib.channels.radio import BigRRadio as channel_list
            elif url == 'DashRadio':
                from resources.lib.channels.radio import DashRadio as channel_list
            elif url == 'GotRadio':
                from resources.lib.channels.radio import GotRadio as channel_list
            elif url == 'SomaFM':
                from resources.lib.channels.radio import SomaFM as channel_list
            elif url == 'WeAreOneFM':
                from resources.lib.channels.radio import WeAreOneFM as channel_list

            elif url == 'AdultSwim':
                from resources.lib.channels.providers import AdultSwim as channel_list
            elif url == 'AnthymTV':
                from resources.lib.channels.providers import AnthymTV as channel_list
            elif url == 'AvoTV':
                from resources.lib.channels.providers import AvoTV as channel_list
            elif url == 'BumbleBeeTV':
                from resources.lib.channels.providers import BumbleBeeTV as channel_list
            elif url == 'DistroTV':
                from resources.lib.channels.providers import DistroTV as channel_list
            elif url == 'FreeliTV':
                from resources.lib.channels.providers import FreeliTV as channel_list
            elif url == 'GalxyTV':
                from resources.lib.channels.providers import GalxyTV as channel_list
            elif url == 'GlewedTV':
                from resources.lib.channels.providers import GlewedTV as channel_list
            elif url == 'HerogoTV':
                from resources.lib.channels.providers import HerogoTV as channel_list
            elif url == 'ImdbTV':
                from resources.lib.channels.providers import ImdbTV as channel_list
            elif url == 'JungoPlusTV':
                from resources.lib.channels.providers import JungoPlusTV as channel_list
            elif url == 'KlowdTV':
                from resources.lib.channels.providers import KlowdTV as channel_list
            elif url == 'LocalbTV':
                from resources.lib.channels.providers import LocalbTV as channel_list
            elif url == 'LocalNow':
                from resources.lib.channels.providers import LocalNow as channel_list
            elif url == 'MuzzikTV':
                from resources.lib.channels.providers import MuzzikTV as channel_list
            elif url == 'MyTvToGo':
                from resources.lib.channels.providers import MyTvToGo as channel_list
            elif url == 'Pbs':
                from resources.lib.channels.providers import Pbs as channel_list
            elif url == 'Plex':
                from resources.lib.channels.providers import Plex as channel_list
            elif url == 'PlutoTV':
                from resources.lib.channels.providers import PlutoTV as channel_list
            elif url == 'RadTV':
                from resources.lib.channels.providers import RadTV as channel_list
            elif url == 'RedBoxTV':
                from resources.lib.channels.providers import RedBoxTV as channel_list
            elif url == 'Roku':
                from resources.lib.channels.providers import Roku as channel_list
            elif url == 'SamsungTV':
                from resources.lib.channels.providers import SamsungTV as channel_list
            elif url == 'SimulTV':
                from resources.lib.channels.providers import SimulTV as channel_list
            elif url == 'SmashPlus':
                from resources.lib.channels.providers import SmashPlus as channel_list
            elif url == 'StirrTV':
                from resources.lib.channels.providers import StirrTV as channel_list
            elif url == 'Stream4Free':
                from resources.lib.channels.providers import Stream4Free as channel_list
            elif url == 'Tcl':
                from resources.lib.channels.providers import Tcl as channel_list
            elif url == 'Tubi':
                from resources.lib.channels.providers import Tubi as channel_list
            elif url == 'TV25':
                from resources.lib.channels.providers import TV25 as channel_list
            elif url == 'VeelyTV':
                from resources.lib.channels.providers import VeelyTV as channel_list
            elif url == 'VisionTV':
                from resources.lib.channels.providers import VisionTV as channel_list
            elif url == 'VizioTV':
                from resources.lib.channels.providers import VizioTV as channel_list
            elif url == 'WatchYourTV':
                from resources.lib.channels.providers import WatchYourTV as channel_list
            elif url == 'Wfmz':
                from resources.lib.channels.providers import Wfmz as channel_list
            elif url == 'Xumo':
                from resources.lib.channels.providers import Xumo as channel_list

            return channel_list.channels
        except:
            log_utils.log('parse_channel_lists', 1)
            return []


